# Отчёт о создании фрагмента технического задания для модуля образовательной среды

## 1. Цель работы

**Цель:**  
Разработка фрагмента технического задания для отдельного модуля образовательной среды, включая описание функциональных и нефункциональных требований, архитектурных компонентов и планирования работы.  

**Задачи:**  
- определить назначение модуля;  
- сформулировать функциональные и нефункциональные требования;  
- описать архитектуру модуля и взаимодействие с остальной системой;  
- оформить отчет в репозитории GitHub с использованием Markdown.

---

## 2. Название и назначение модуля

**Название модуля:** Модуль отслеживания прогресса обучающихся  

**Назначение модуля:**  
- автоматический подсчёт выполнения учебных заданий;  
- визуализация прогресса прохождения курсов;  
- предоставление преподавателю инструментов анализа результатов студентов;  
- интеграция с уведомлениями и другими компонентами образовательной среды.

---

## 3. Функциональные требования

| № | Функция | Описание |
|---|---------|----------|
| 1 | Отслеживание выполнения модулей | Сбор информации о завершении заданий и тестов пользователями |
| 2 | Визуализация прогресса | Графическое отображение процента выполнения курса и модулей |
| 3 | Уведомления о статусе | Отправка уведомлений пользователю о незавершённых заданиях и достигнутых этапах |
| 4 | Отчётность для преподавателя | Формирование отчётов по прогрессу студентов, фильтрация и сортировка данных |
| 5 | История изменений | Хранение данных о прогрессе пользователей для анализа динамики обучения |

---

## 4. Нефункциональные требования

- **Производительность:** обработка данных до 500 пользователей одновременно;  
- **Безопасность:** шифрование данных и защита от несанкционированного доступа;  
- **Масштабируемость:** возможность расширения функционала (например, новые виды аналитики);  
- **Совместимость:** интеграция с существующими модулями образовательной среды;  
- **Удобство использования:** интуитивный интерфейс с минимальной нагрузкой на пользователя.

---

## 5. Архитектура модуля

**Общая архитектура:** модуль клиент-серверного типа с фронтенд и бэкенд компонентами.  

**Компоненты модуля:**
- **Frontend:** пользовательский интерфейс для обучающихся и преподавателей (React/Vue, HTML, CSS, JS);  
- **Backend:** логика подсчёта прогресса, хранение и обработка данных (Node.js/Python/Java);  
- **Database:** хранение информации о выполнении заданий и результатах (PostgreSQL/MySQL);  
- **Notification Service:** отправка уведомлений пользователям;  
- **Analytics Engine:** генерация графиков и статистических отчётов.

**Взаимодействие с другими модулями:**  
- Подключение к модулю курсов для получения списка заданий;  
- Передача данных в модуль уведомлений для информирования пользователей;  
- Передача агрегированных данных в модуль аналитики для составления отчётов.

---

## 6. Планирование работы

**Этапы разработки:**
1. Анализ требований и согласование с преподавателем/заказчиком — 1.5 часа  
2. Определение функционального набора — 1 час  
3. Создание прототипа интерфейса — 2 часа  
4. Описание архитектуры и взаимодействия с другими модулями — 1.5 часа  
5. Оформление фрагмента ТЗ в Markdown — 1 час  
6. Проверка и правки — 0.5 часа  

**Итого:** 7.5 часов